import { View, FlatList, Dimensions, Text, Pressable } from "react-native";
import React from "react";
import Onboard1 from "../Onboard1/Onboard1";
import Illustration1 from "../../../assets/svgs/illustration-1.svg";
import Illustration2 from "../../../assets/svgs/illustration-2.svg";
import Illustration3 from "../../../assets/svgs/illustration-3.svg";
import { OnboardStyle } from "./OnboardStyle";
import { useState } from "react";
import { Onboard1Style } from "../Onboard1/Onboard1Style";
import NextButton from "../../../assets/svgs/refund/rightArrow.svg";
import { useRef } from "react";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const { width } = Dimensions.get("window");

const slider = [
    {
        key: 1,
        OnboardIcon: Illustration1,
        title1: "Your",
        title2: "all-in-one",
        title3: "online shopping",
        title4: "solution",
        text1: "We provide everything that you desire",
        text2: "from an e-commerce",
    },
    {
        key: 2,
        OnboardIcon: Illustration2,
        title1: "Fully",
        title2: "optimized",
        title3: "& secured for you",
        title4: "to shop at ease",
        text1: "We provide multiple payment methods",
        text2: "with powerful transaction security",
    },
    {
        key: 3,
        OnboardIcon: Illustration3,
        title1: "Bringing you",
        title2: "the best shopping",
        title3: "experience",
        title4: "",
        text1: "Made with love by the best",
        text2: "designers & developers",
    },
];

const Onboard = ({ navigation }) => {
    const { trans } = useLangTranslation();
    const [currentSlideIndex, setCurrentSlideIndex] = useState(0);
    const ref = useRef(null);
    const Slide = ({ item }) => {
        return <Onboard1 item={item} currentSlideIndex={currentSlideIndex} />;
    };
    const Header = () => {
        return (
            <View style={OnboardStyle.indicatorContainer}>
                {slider.map((_, index) => (
                    <View
                        key={index}
                        style={[
                            OnboardStyle.indicator,
                            currentSlideIndex === index && OnboardStyle.activeIndicator,
                        ]}
                    />
                ))}
            </View>
        );
    };
    const Footer = () => {
        return (
            <>
                {currentSlideIndex === slider.length - 1 ? (
                    <View style={Onboard1Style.move}>
                        <Pressable
                            onPress={() => navigation.replace("DrawerStack")}
                            style={OnboardStyle.getStart}
                        >
                            <Text style={OnboardStyle.getStartText}>
                                {trans("Get Started")}
                            </Text>
                        </Pressable>
                    </View>
                ) : (
                    <View style={Onboard1Style.move}>
                        <Pressable onPress={skipSlide}>
                            <Text style={Onboard1Style.skip}>Skip</Text>
                        </Pressable>
                        <Pressable
                            onPress={goNextSlide}
                            style={OnboardStyle.nextBtn}
                        >
                            <CustomSVG svgIcon={NextButton}
                                height={dpr(15)}
                                width={dpr(24)}
                                fill={"#2C2C2C"}
                            />
                        </Pressable>
                    </View>
                )}
            </>
        );
    };

    const updateCurrentSlideIndex = (e) => {
        const contentOffsetX = e.nativeEvent.contentOffset.x;
        const currentIndex = Math.round(contentOffsetX / width);
        setCurrentSlideIndex(currentIndex);
    };
    const goNextSlide = () => {
        const nextSlideIndex = currentSlideIndex + 1;
        if (nextSlideIndex !== slider.length) {
            const offset = nextSlideIndex * width;
            ref?.current?.scrollToOffset({ offset });
            setCurrentSlideIndex(nextSlideIndex);
        }
    };
    const skipSlide = () => {
        navigation.navigate("DrawerStack");
    };
    return (
        <>
            <Header />
            <FlatList
                ref={ref}
                data={slider}
                horizontal
                renderItem={({ item }) => <Slide item={item} />}
                showsHorizontalScrollIndicator={false}
                pagingEnabled
                onMomentumScrollEnd={updateCurrentSlideIndex}
                scrollEnabled={false}
            />
            <Footer />
        </>
    );
};

export default Onboard;
